﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="System.Globalization" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
        <style type="text/css">
            tr { height: 14pt }
        </style>
		<title>Lista obecności</title>
		<script runat="server">

            class PracInfo {
                readonly SrParams srpars;
                readonly Periods okresy = Periods.Empty;
                readonly FromTo okres;
                readonly object[] dni;
                readonly Log log;

                public PracInfo(Pracownik pracownik, string wydzial, FromTo okres, SrParams srpars, Log log) {
                    this.srpars = srpars;
                    this.okres = okres;
                    this.log = log;
                    dni = new object[okres.Days];

                    foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                        if ((ph.Etat.EfektywnyOkres * okres) != FromTo.Empty && ((ph.Etat.Wydzial != null && ph.Etat.Wydzial.Nazwa == wydzial) || srpars.BezPodzialuNaWydzialy))
                            okresy = okresy + ph.Etat.EfektywnyOkres;

                    try {
                        okresy = okresy.ToFlat() * okres;
                        KalkulatorPracy praca = new KalkulatorPracy(pracownik);
                        praca.LoadOkres(okresy.Outer);

                        if (srpars.Nieobecnosci || srpars.NieobecnosciNb)
                        foreach (FromTo o in okresy) {
                            foreach (OkresNieobecności on in praca.Nieobecnosci(o, true))
                                foreach (Date d in on.Okres)
                                    if (!srpars.NieobecnosciWgTypuDnia || on.Definicja.TypDni == TypyDni.Kalendarzowe || praca.Plan[d].Definicja.Typ == TypDnia.Pracy)
                                        dni[d - okres.From] = on.Definicja;
                        }

                        foreach (FromTo o in okresy)
                            foreach (Date d in o)
                                if (dni[d - okres.From] == null)
                                    dni[d - okres.From] = praca.Plan[d];
                    }
                    catch {
                        log.WriteLine("Błąd dla " + pracownik + " - próba wykonania raportu dla pracownika rozliczanego wg zestawień czasu pracy w okresie: " + okres);
                    }
                }

                public object this[Date data] {
                    get {
                        if (!okresy.Contains(data))
                            return false;
                        return dni[data - okres.From];
                    }
                }
            }
	
	class LpPage {
        readonly SrParams srpars;
        readonly Log log;
        FromTo okres;
		ArrayList pracownicy = new ArrayList();
		ArrayList info = new ArrayList();
		string wydzial;
		int nr;
		public LpPage(string wydzial, FromTo okres, int nr, SrParams srpars, Log log) {
            this.srpars = srpars;
            this.log = log;
            this.wydzial = wydzial;
			this.okres = okres;
			this.nr = nr;
		}
		public LpPage(LpPage page) {
            this.srpars = page.srpars;
            this.log = page.log;
			this.wydzial = page.Wydzial;
			this.okres = page.okres;
			this.nr = page.Nr + 1;
		}
		public string Wydzial {
			get { return wydzial; }
		}
		public int Nr {
			get { return nr; }
		}
		public ArrayList Pracownicy {
			get { return pracownicy; }
		}
		public Pracownik this [int i] {
			get {
				if (i<pracownicy.Count)
					return (Pracownik)pracownicy[i];
				return null;
			}
		}
		public object this [int i, Date data] {
			get {
				if (i<pracownicy.Count)
					return ((PracInfo)info[i])[data];
				return null;
			}
		}
		public void Add(Pracownik pracownik) {
			pracownicy.Add(pracownik);
			info.Add(new PracInfo(pracownik, wydzial, okres, srpars, log));
		}
	}
	
	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			Date data;
			if (context.Contains(typeof(ActualDate)))
				data = ((ActualDate)context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
			miesiac = new YearMonth(data)+1;
		}
		
		YearMonth miesiac;
		[Required]
		[Priority(10)]
		[Caption("Lista obecności za")]
		public YearMonth Miesiac {
			get { return miesiac; }
			set { 
				miesiac = value; 
				OnChanged(EventArgs.Empty);
			}
		}			
		
		bool wszyscy = true;
		[Priority(20)]
		[Caption("Wydruk dla wszystkich")]
		public bool Wszyscy {
			get { return wszyscy; }
			set { 
				wszyscy = value; 
				OnChanged(EventArgs.Empty);
			}
		}		
		
		Wydzial wydzial;
		[Priority(30)]
		[Caption("Wybrany wydział")]
		public Wydzial Wydzial {
			get { return wydzial; }
			set { 
				wydzial = value; 
				OnChanged(EventArgs.Empty);
			}
		}            
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool tylkoPracownicyZatrudnieni = true;
        [Priority(10)]
        [Caption("Tylko zatrudnieni")]
        public bool TylkoPracownicyZatrudnieni {
            get { return tylkoPracownicyZatrudnieni; }
            set {
                tylkoPracownicyZatrudnieni = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Sposób pokazywania nieobecności liczonych w dniach pracy.
        //Pole ustawione na true oznacza, że takie nieobecności są wykazywane
        //tylko w dni pracy.    
        //const bool nieobecnościWgTypuDnia = false;
        bool nieobecnosciWgTypuDnia = false;
        [Priority(20)]
        [Caption("Nieobecn. wg typu dnia")]
        public bool NieobecnosciWgTypuDnia {
            get { return nieobecnosciWgTypuDnia; }
            set {
                nieobecnosciWgTypuDnia = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Zostanie wydrykowana płaska lista pracowników bez podziału na wydziały    
        //const bool bezPodziałuNaWydziały = false;
        bool bezPodzialuNaWydzialy = false;
        [Priority(30)]
        [Caption("Bez podz. na wydziały")]
        public bool BezPodzialuNaWydzialy {
            get { return bezPodzialuNaWydzialy; }
            set {
                bezPodzialuNaWydzialy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool poziomo = false;
        [Priority(40)]
        [Caption("Nazwisk.poziomo(Excel)")]
        public bool Poziomo {
            get { return poziomo; }
            set {
                poziomo = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool nieobecności = true;
        [Priority(50)]
        [Caption("Pokaż nieobecności")]
        public bool Nieobecnosci {
            get { return nieobecności; }
            set {
                nieobecności = value;
             if (value)
                    NieobecnosciNb = false;
                OnChanged(EventArgs.Empty);
            }
        }

        [Priority(60)]
        [Caption("Nieobecność jako Nb")]
        public bool NieobecnosciNb { get; set; }

        public bool IsReadOnlyNieobecnosciNb() {
           if (Nieobecnosci)
               return true;
           return false;
            }
    }

	PrnParams pars = null; 
	[Context] 
	public PrnParams Params { 
		set { pars = value; } 
	}

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
		                
	string title;
	
	KalkulatorKalendarza kalkK;
    Log log = new Log("Wydruk: Lista obecności - podpisy", true);

	void OnContextLoad(Object sender, EventArgs args) {
        dc.Landscape = srpars.Poziomo;
        Grid1.Columns[1].Width = Grid2.Columns[1].Width = 3;
        Grid1.Columns[12].Width = Grid2.Columns[12].Width = 25;
        for (int col = 2; col <= 11; col++)
            Grid1.Columns[col].Width = Grid2.Columns[col].Width = (srpars.Poziomo ? 12 : 8);
        
        title = ReportHeader1.Title;

        colMonth.Caption = string.Format("<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; TEXT-ALIGN: center'>{0}</SPAN><br/><SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; TEXT-ALIGN: center'>{1}</SPAN>",
            pars.Miesiac.ToString("MMMM", CultureInfo.CurrentCulture).ToUpper(),
            pars.Miesiac.ToString("yyyy", CultureInfo.CurrentCulture));
		FromTo okres = (FromTo)pars.Miesiac;

		kalkK = new KalkulatorKalendarza(KalendModule.GetInstance(dc).Kalendarze.Standard);
		kalkK.LoadOkres(okres);
						
		Hashtable wydzialy = new Hashtable();
        	
        IEnumerable rows;
        if (!pars.Wszyscy)
            rows = (Pracownik[])dc[typeof(Pracownik[])];
        else
            if (srpars.TylkoPracownicyZatrudnieni)
                rows = KadryModule.GetInstance(dc).Pracownicy.GetNaEtatach(okres, (Wydzial)null, false, true);
            else
                rows = KadryModule.GetInstance(dc).Pracownicy;
        
        Hashtable pracownicy = null;
        foreach (Pracownik pracownik in rows)
            if (pracownik is PracownikFirmy)
                foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
                    if ((ph.Etat.EfektywnyOkres * okres) != FromTo.Empty || !srpars.TylkoPracownicyZatrudnieni)
                        if (pars.Wydzial == null || ph.Etat.Wydzial == pars.Wydzial) {
                            if (!srpars.BezPodzialuNaWydzialy || pracownicy == null) {
                                object key = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Nazwa : string.Empty;
                                pracownicy = (Hashtable)wydzialy[key];
                                if (pracownicy == null)
                                    wydzialy.Add(key, pracownicy = new Hashtable());
                            }
                            pracownicy[pracownik] = true;
                        }
				
		ArrayList lw = new ArrayList(wydzialy.Keys);
		lw.Sort();
		
		ArrayList pages = new ArrayList();
		LpPage page;
		foreach (object key in lw) {
			ArrayList pracownicy2 = new ArrayList(((Hashtable)wydzialy[key]).Keys);
			pracownicy2.Sort();
			pages.Add(page = new LpPage(key as string, okres, 1, srpars, log));
			foreach (Pracownik pracownik in pracownicy2) {
				if (page.Pracownicy.Count==10)
					pages.Add(page=new LpPage(page));
				page.Add(pracownik);			
			}
		}
		
		DataRepeater1.DataSource = pages;
		Grid1.DataSource = new object[] {};
		
		int[] days = new int[pars.Miesiac.Days];
		for (int i=0; i<pars.Miesiac.Days; i++)
			days[i] = i+1;
		Grid2.DataSource = days;
	}
	
	string Caption(string s) {
        if (!srpars.Poziomo) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i<s.Length; i++) {
                if (i>0)
                    sb.Append("<br>");
                sb.Append(s[i]);
            } 		
            return sb.ToString();
        }
        else
            return s;
	}

	LpPage currentPage;
	
	void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
		ReportHeader1.Title = title;
		currentPage = (LpPage)DataRepeater1.CurrentRow;
        ReportHeader1["WYDZIAL"] = currentPage.Wydzial;
		ReportHeader1["NR"] = currentPage.Nr.ToString();
		
		Grid1_BeforeRender(currentPage);
	}

	static readonly string headerStyle = "style='FONT-SIZE: 6pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse; overflow: hidden; table-layout: fixed;'";
	static readonly string headerFormat = "<TABLE {3} cellSpacing='0' cellPadding='0' width='100%' border='0'><TR><TD vAlign='bottom' align='center' width='34%'>{0}</TD><TD vAlign='bottom' align='center' width='33%'><B>{1}</B></TD><TD vAlign='bottom' align='center'><B>{2}</B></TD></TR></TABLE>";
	
	static readonly string wolnyFormat = "<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: yellow; TEXT-ALIGN: center'>{0}</SPAN>";
	static readonly string swietoFormat = "<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: gold; TEXT-ALIGN: center'>{0}</SPAN>";
	static readonly string normalFormat = "<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; TEXT-ALIGN: center'>{0}</SPAN>";
	static readonly string nieobecFormat = "<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: silver; TEXT-ALIGN: center'>{0}</SPAN>";
	static readonly string zwolnFormat = "<SPAN style='FONT-SIZE: 8pt; WIDTH: 100%; FONT-FAMILY: Tahoma; HEIGHT: 14pt; BACKGROUND-COLOR: gainsboro; TEXT-ALIGN: center'>{0}</SPAN>";
	
	string FormatHeader(string s1, string s2, string s3) {
        if (!srpars.Poziomo)
		    return string.Format(headerFormat, Caption(s1), Caption(s2), Caption(s3), headerStyle);
        else
            return s1 + "<br />" + s2 + "<br />" + s3;
	}
	
    void Grid1_BeforeRender(LpPage page) {
		for (int i=1; i<=10; i++) {
			Pracownik p = page[i-1];
			
			if (p==null)
				Grid1.Columns[i+1].Caption = FormatHeader("", "", "");
			else {
				string nazwisko = p.Nazwisko;
				int j = nazwisko.IndexOf('-');
				if (j==-1) {
					Grid1.Columns[i+1].Caption = FormatHeader(p.Imie, nazwisko, "");
				}
				else {
					Grid1.Columns[i+1].Caption = FormatHeader(
						p.Imie,
						nazwisko.Substring(0, j+1),
						nazwisko.Substring(j+1, nazwisko.Length - j - 1));
				}
			}
		}
    }

    void Grid2_BeforeRow(Object sender, RowEventArgs args) {
		int day = (int)args.Row;
		Date date = pars.Miesiac.FirstDay + (day - 1);
		string format;
		string stdformat;
		switch (kalkK[date].Definicja.Typ) {
			case TypDnia.Pracy:
				format = normalFormat; colWDay.BgColor = "white"; colDay.BgColor = "white"; break;
			case TypDnia.Wolny:
				format = wolnyFormat; colWDay.BgColor = "yellow"; colDay.BgColor = "yellow"; break;
			case TypDnia.Świąteczny:
				format = swietoFormat; colWDay.BgColor = "gold"; colDay.BgColor = "gold"; break;
			default:
				format = "?"; break;
		}
		
		stdformat = format;
		
		colWDay.EditValue = string.Format(format, date.ToString("dddd", CultureInfo.CurrentCulture));
		colDay.EditValue = string.Format(format, date.ToString("dd", CultureInfo.CurrentCulture));
		
		for(int i=0; i<11; i++) {
            object v = currentPage[i, date];
            string s = "";
            if (v==null)				//Brak pracownika lub Niezatrudniony			
                switch (kalkK[date].Definicja.Typ) {
                    case TypDnia.Pracy:
                        format = stdformat; Grid2.Columns[i+2].BgColor = "white"; break;
                    case TypDnia.Wolny:
                        format = stdformat; Grid2.Columns[i+2].BgColor = "yellow"; break;
                    case TypDnia.Świąteczny:
                        format = stdformat; Grid2.Columns[i+2].BgColor = "gold"; break;
                    default:
                        format = "?"; break;
                }
            else if (v is bool) {
                format = zwolnFormat;
                Grid2.Columns[i + 2].BgColor = "gainsboro";
            }
            else if (v is DefinicjaNieobecnosci) {	//Nieobecność
                s =  srpars.NieobecnosciNb ? "Nb".Translate() : ((DefinicjaNieobecnosci)v).Skrot;
                format = nieobecFormat;
                Grid2.Columns[i + 2].BgColor = "silver";
            }
            else
                switch (((Dzien)v).Definicja.Typ) {
                    case TypDnia.Pracy:
                        format = normalFormat; Grid2.Columns[i + 2].BgColor = "white"; break;
                    case TypDnia.Wolny:
                        format = wolnyFormat; Grid2.Columns[i + 2].BgColor = "yellow"; break;
                    case TypDnia.Świąteczny:
                        format = swietoFormat; Grid2.Columns[i + 2].BgColor = "gold"; break;
                    default:
                        format = "?"; break;
            }
            Grid2.Columns[i+2].EditValue = string.Format(format, s);
		}
    }
    
	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}

		</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ListaObecności" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business" oncontextload="OnContextLoad"
                LeftMargin="-5" TopMargin="-5" RightMargin="-5" BottomMargin="-5"></ea:datacontext>
            <ea:datarepeater id="DataRepeater1" runat="server" onbeforerow="DataRepeater1_BeforeRow" Width="100%">
					<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
					<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
					<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title='Lista obecności|</STRONG>Wydział: <STRONG>%WYDZIAL%</STRONG>|Opiekun listy obecności: ................................................|str. <STRONG>%NR%</STRONG>'
						runat="server"></cc1:reportheader>
						<ea:grid id="Grid1" runat="server">
							<Columns>
								<ea:GridColumn Align="Center" ID="colMonth"></ea:GridColumn>
								<ea:GridColumn Caption=""></ea:GridColumn>
								<ea:GridColumn Caption="H1"></ea:GridColumn>
								<ea:GridColumn Caption="H2"></ea:GridColumn>
								<ea:GridColumn Caption="H3"></ea:GridColumn>
								<ea:GridColumn Caption="H4"></ea:GridColumn>
								<ea:GridColumn Caption="H5"></ea:GridColumn>
								<ea:GridColumn Caption="H6"></ea:GridColumn>
								<ea:GridColumn Caption="H7"></ea:GridColumn>
								<ea:GridColumn Caption="H8"></ea:GridColumn>
								<ea:GridColumn Caption="H9"></ea:GridColumn>
								<ea:GridColumn RightBorder="Double" Caption="H10"></ea:GridColumn>
								<ea:GridColumn Caption="Podpis|*)"></ea:GridColumn>
							</Columns>
						</ea:grid>
						<ea:grid id="Grid2" runat="server" ShowHeader="None" OnBeforeRow="Grid2_BeforeRow">
							<Columns>
								<ea:GridColumn Align="Center" ID="colWDay"></ea:GridColumn>
								<ea:GridColumn RightBorder="Double" Align="Center" ID="colDay"></ea:GridColumn>
								<ea:GridColumn Caption="P1" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P2" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P3" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P4" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P5" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P6" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P7" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P8" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P9" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn RightBorder="Double" Caption="P10" NoWrap="True"></ea:GridColumn>
								<ea:GridColumn Caption="P"></ea:GridColumn>
							</Columns>
						</ea:grid>
    					<div style="FONT-SIZE: 8pt; FONT-FAMILY: Tahoma">
                            *) podpis kierownika działu lub osoby upoważnionej
    					</div>
						<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
					<ea:SectionMarker id="SectionMarker2" runat="server" SectionType="Footer"></ea:SectionMarker>
				</ea:datarepeater>
		</form>
	</body>
</HTML>
